//************************************************************
//---------------XiAn AnaDig IC Inc.(XAD-IC)------------------
//-----------------C File Standard--------------------
//************************************************************
//#Author      : mjw
//#Case name   : io_rw
//#Function    : Timer1_Capture   PA4作为捕捉通道，TIMER1作为捕捉定时器，下降沿触发；通过uart打印查看捕捉时长
//************************************************************
#include "AD18F08_Com.h"
#include "AD18F08.h"
#include <stdio.h>
#include "periph.h"
#include "AD18F08_Com.h"


__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_ON_1L     & _LVR24V_1L                                                                   );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTEN_OFF_3L    & _TWDT_000_3L                                                                 );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _ADCSP_ON_4L                                                                                                        );

uint16_t ccpr_temp;

bit succee_flag;


/***********************************************************************
 *
 *
 *
 *
 *
 * Note:PA4作为采集通道   TIMER1时钟源为Fcpu 1/4分频 = 1MHz；   Uart_BPS = 9600  Tx = PB1
***********************************************************************/
void main(void)
{
	GPIO_Init();
    usart_init();
    printf("AD18F08_test\r\n");
	Timer1_Timer();
    CCP_init();
    IPEN = 0;	   	//禁止中断优先级
    PEIE = 1;    	//外设GIEL
    GIE = 1;     	//全局GIEH
    succee_flag = 0;
    while(1)
    {
        if(succee_flag==1)
        {
            succee_flag=0;
            ccpr_temp=((CCPR1H<<8) | CCPR1L);       //读取捕捉值
            GIE = 0;
            printf ("period=%d us\r\n",ccpr_temp);
            CCPIF=0;
            GIE = 1;
        }

    }
}

void interrupt ISR(void)
{
   if(CCPIE == 1 && CCPIF == 1)
   {
		CCPIF = 0;
        succee_flag = 1;
   }
}

